//
//  Home.swift
//  Do It
//
//  Created by Jim Dovey on 5/20/20.
//  Copyright © 2020 Pragmatic Programmers. All rights reserved.
//

import SwiftUI

struct Home: View {
    var body: some View {
        // START:ChooserBody
        NavigationView {
            List {
                // <literal:elide> ... </literal:elide>
                // END:ChooserBody
                // START:AllItemsSection
                Section {
                    NavigationLink(destination: TodoList()) {
                        Row(name: "All Items",
                            icon: "list.bullet",
                            color: .gray)
                    }
                }
                // END:AllItemsSection
                
                // START:ListsSection
                Section {
                    ForEach(defaultTodoLists) { list in
                        NavigationLink(destination: TodoList(list: list)) {
                            Row(name: list.name,
                                icon: list.icon,
                                color: list.color.uiColor)
                        }
                    }
                }
                // END:ListsSection
                // START:ChooserBody
            }
            .font(.system(.headline, design: .rounded))
            .listStyle(GroupedListStyle())
            .navigationBarTitle("Lists")
        }
        // END:ChooserBody
    }
    
    // START:ListItemRow
    private struct Row: View {
        // END:ListItemRow
        // START:ListRowProperties
        var name: String
        var icon: String
        var color: Color
        // END:ListRowProperties
        // START:ListItemRow
        
        // START:ListRowBody
        var body: some View {
            // END:ListRowBody
            // <literal:elide> ... </literal:elide>
            // END:ListItemRow
            // START:ListRowBody
            HStack {
                Image(systemName: icon) // <label id="code.ch2.list.row.icon" />
                    .foregroundColor(.white)
                    .frame(width: 32, height: 32) // <label id="code.ch2.list.row.frame" />
                    .background(color)
                    .clipShape(Circle()) // <label id="code.ch2.list.row.clip" />
                Text(name)
            }
            // START:ListItemRow
        }
        // END:ListRowBody
    }
    // END:ListItemRow
}

struct Home_Previews: PreviewProvider {
    static var previews: some View {
        Home()
    }
}
